import {FunctionComponent} from 'react';

import {IWithDeviceType} from 'types/withDeviceType';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import TextHotelsReviewSkeleton from './components/TextHotelReviewSkeleton/TextHotelReviewSkeleton';

import cx from './TextHotelReviewsSkeleton.scss';

export interface ITextHotelReviewsSkeletonProps
    extends IWithDeviceType,
        IWithQaAttributes {
    hideKeyPhrases?: boolean;
}

const TextHotelReviewsSkeleton: FunctionComponent<ITextHotelReviewsSkeletonProps> =
    props => {
        const {deviceType} = props;

        return (
            <div
                className={cx('root', {root_mobile: deviceType.isMobile})}
                {...prepareQaAttributes(props)}
            >
                <div className={cx('reviews')}>
                    <TextHotelsReviewSkeleton />
                    <TextHotelsReviewSkeleton />
                    <TextHotelsReviewSkeleton />
                </div>
            </div>
        );
    };

export default TextHotelReviewsSkeleton;
