import {FunctionComponent} from 'react';

import Card from 'components/Card/Card';
import Stars from 'components/Stars/Stars';
import LikeOutlineIcon from 'icons/16/LikeOutline';
import DislikeOutlineIcon from 'icons/16/DislikeOutline';

import cx from './TextHotelReviewSkeleton.scss';

const TextHotelReviewSkeleton: FunctionComponent = () => (
    <Card className={cx('card')} shadow="default">
        <div className={cx('user')}>
            <div className={cx('avatar')} />
            <div className={cx('user__info')}>
                <div className={cx('name')} />
                <div className={cx('rating')}>
                    <Stars starCount={0} totalStarCount={5} />
                </div>
            </div>
        </div>
        <div>
            <div className={cx('text', 'text_comment')} />
            <div className={cx('text', 'text_comment')} />
            <div className={cx('text', 'text_comment')} />
        </div>
        <div className={cx('reaction')}>
            <LikeOutlineIcon className={cx('icon')} />
            <div className={cx('text', 'text_like')} />
            <DislikeOutlineIcon className={cx('icon')} />
            <div className={cx('text', 'text_dislike')} />
        </div>
    </Card>
);

export default TextHotelReviewSkeleton;
