import React from 'react';

import * as i18nBlock from 'i18n/hotels-HotelReviews';

import ModalOrBottomSheet from 'components/ModalOrBottomSheet/ModalOrBottomSheet';
import Text from 'components/Text/Text';
import Heading from 'components/Heading/Heading';
import Button from 'components/Button/Button';
import Flex from 'components/Flex/Flex';
import SubTicketsThankYouM from 'icons/illustrations/SubTicketsThankYou/SubTicketsThankYouM';

import cx from './CreateReviewSuccessDialog.scss';

interface ICreateReviewSuccessDialogProps {
    isVisible: boolean;
    onClose: () => void;
}

const CreateReviewSuccessDialog: React.FC<ICreateReviewSuccessDialogProps> = ({
    isVisible,
    onClose,
}) => {
    return (
        <ModalOrBottomSheet
            isVisible={isVisible}
            onClose={onClose}
            modalProps={{hasCloseButton: false}}
            modalContentProps={{className: cx('modal')}}
        >
            <Flex
                flexDirection="column"
                alignItems="center"
                justifyContent="center"
                between={1}
            >
                <SubTicketsThankYouM className={cx('illustration')} />
                <Heading level="2">{i18nBlock.successDialogTitle()}</Heading>

                <Text size="m" tag="div" className={cx('description')}>
                    {i18nBlock.successDialogDescription()}
                </Text>
                <Button
                    theme="primary"
                    width="max"
                    size="l"
                    type="button"
                    className={cx('button')}
                    onClick={onClose}
                >
                    {i18nBlock.successDialogButtonText()}
                </Button>
            </Flex>
        </ModalOrBottomSheet>
    );
};

export default CreateReviewSuccessDialog;
