import React, {createContext, useCallback, useState} from 'react';
import {noop} from 'lodash';

import {
    INewImagesSelectorImage,
    TImagesSelectorImage,
} from 'components/ImagesSelector/types/IImagesSelectorImage';

interface IImageUploaderContext {
    images: readonly INewImagesSelectorImage[];
    addImage: (image: INewImagesSelectorImage) => void;
    removeImage: (image: TImagesSelectorImage) => void;
    imageStateChange: (image: TImagesSelectorImage) => void;
    clear: () => void;
    deletedServerImageIds: string[];
}

export const ImageUploaderContext = createContext<IImageUploaderContext>({
    images: [],
    addImage: noop,
    removeImage: noop,
    imageStateChange: noop,
    clear: noop,
    deletedServerImageIds: [],
});

const ImageUploaderContextProvider: React.FC = ({children}) => {
    const [images, setImages] = useState<INewImagesSelectorImage[]>([]);
    const [deletedServerImageIds] = useState<string[]>([]);

    const addImage = useCallback(
        image => {
            setImages([...images, image]);
        },
        [images, setImages],
    );
    const removeImage = useCallback(
        image => {
            setImages(images.filter(i => i !== image));
        },
        [images, setImages],
    );
    const imageStateChange = useCallback(() => {
        setImages([...images]);
    }, [images, setImages]);
    const clear = useCallback(() => setImages([]), [setImages]);

    return (
        <ImageUploaderContext.Provider
            value={{
                images,
                addImage,
                removeImage,
                imageStateChange,
                clear,
                deletedServerImageIds,
            }}
        >
            {children}
        </ImageUploaderContext.Provider>
    );
};

export default ImageUploaderContextProvider;
