import {ISortInfo, ESortTypeHint} from 'types/hotels/search/ISortInfo';

import * as i18nReviewsSortingOptionsBlock from 'i18n/hotels-HotelReviewsSortingOptions';

export const REVIEW_PLACEHOLDERS_COUNT = 1;
export const SET_REVIEW_REACTION_DEBOUNCE = 2000;
export const REVIEWS_LOAD_COUNT = 5;
export const KEY_PHRASES_SHOW_LIMIT = 7;

export const REVIEWS_SORTING_INFO: ISortInfo = {
    availableSortTypeGroups: [
        {
            id: 'ETextReviewRankingType.RELEVANCE_ORG',
            name: i18nReviewsSortingOptionsBlock.byRelevanceOrg(),
            requiresGeoLocation: false,
            sortTypes: [
                {
                    id: 'ETextReviewRankingType.RELEVANCE_ORG',
                    name: i18nReviewsSortingOptionsBlock.byRelevanceOrg(),
                    hint: ESortTypeHint.descending,
                },
            ],
        },
        {
            id: 'ETextReviewRankingType.TIME',
            name: i18nReviewsSortingOptionsBlock.byTime(),
            requiresGeoLocation: false,
            sortTypes: [
                {
                    id: 'ETextReviewRankingType.TIME',
                    name: i18nReviewsSortingOptionsBlock.byTime(),
                    hint: ESortTypeHint.descending,
                },
            ],
        },
        {
            id: 'ETextReviewRankingType.RATING_ASC',
            name: i18nReviewsSortingOptionsBlock.byRatingAsc(),
            requiresGeoLocation: false,
            sortTypes: [
                {
                    id: 'ETextReviewRankingType.RATING_ASC',
                    name: i18nReviewsSortingOptionsBlock.byRatingAsc(),
                    hint: ESortTypeHint.descending,
                },
            ],
        },
        {
            id: 'ETextReviewRankingType.RATING_DESC',
            name: i18nReviewsSortingOptionsBlock.byRatingDesc(),
            requiresGeoLocation: false,
            sortTypes: [
                {
                    id: 'ETextReviewRankingType.RATING_DESC',
                    name: i18nReviewsSortingOptionsBlock.byRatingDesc(),
                    hint: ESortTypeHint.descending,
                },
            ],
        },
    ],
};
