import {ReactNode} from 'react';

import {EProjectName} from 'constants/common';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';
import {EFooterProject} from 'components/Footer/types';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import LayoutDefault from 'components/Layouts/LayoutDefault/LayoutDefault';

/* Component Types */
export interface IHotelsBookLayoutProps
    extends IWithClassName,
        IWithDeviceType,
        IWithQaAttributes {
    children: ReactNode;
    hasLoader: boolean;
}

/* Init styles */
import cx from './HotelsBookLayout.scss';

const HotelsBookLayout = (props: IHotelsBookLayoutProps) => {
    const {
        className,
        hasLoader,
        children,
        deviceType: {isDesktop, isIe},
    } = props;

    return (
        <LayoutDefault
            className={cx(
                {hotelsBookLayout_hasIELoader: isIe && hasLoader},
                className,
            )}
            project={EProjectName.HOTELS}
            footerType={EFooterProject.HOTELS_BOOKING}
            showNavigation={isDesktop}
            {...prepareQaAttributes(props)}
        >
            {children}
        </LayoutDefault>
    );
};

export default HotelsBookLayout;
