import moment from 'moment';

import {HUMAN} from 'utilities/dateUtils/formats';
import {MOSCOW_TIME_ZONE} from 'utilities/dateUtils/timezones';

const DEFAULT_DAY_DIFF = 7;

export const prepareCancellationDateTime = (
    date: string,
    format: string = HUMAN,
): string => moment.utc(date).tz(MOSCOW_TIME_ZONE).format(format);

export const checkCancellationDateTimeDiffByNowDate = (
    date: string,
    dayDiff: number = DEFAULT_DAY_DIFF,
): boolean =>
    Boolean(date) &&
    moment
        .utc(date)
        .tz(MOSCOW_TIME_ZONE)
        .diff(moment().tz(MOSCOW_TIME_ZONE), 'days') < dayDiff;
