import {ReactElement} from 'react';

import {IRefundRule} from 'types/hotels/offer/IHotelOfferCancellationInfo';
import {IWithClassName} from 'types/withClassName';

import HotelsCancellationTextRule from './components/HotelsCancellationTextRule/HotelsCancellationTextRule';

import cx from './HotelsCancellationTextInfo.scss';

interface IHotelsCancellationTextInfoProps extends IWithClassName {
    refundRules: IRefundRule[];
}

const HotelsCancellationTextInfo = (
    props: IHotelsCancellationTextInfoProps,
): ReactElement => {
    const {refundRules, className} = props;

    return (
        <div className={cx(className)}>
            {refundRules.map((refundRule, index) => (
                <HotelsCancellationTextRule
                    key={index}
                    className={cx('rule')}
                    refundRule={refundRule}
                />
            ))}
        </div>
    );
};

export default HotelsCancellationTextInfo;
