import {ReactElement} from 'react';

import {IRefundRule} from 'types/hotels/offer/IHotelOfferCancellationInfo';
import {IWithClassName} from 'types/withClassName';

import {getCancellationTextRuleOptions} from 'projects/depreacted/hotels/components/HotelsCancellationTextInfo/components/HotelsCancellationTextRule/utilities/getCancellationTextRuleOptions';
import {getCancellationRuleDate} from 'projects/depreacted/hotels/components/HotelsCancellationTextInfo/components/HotelsCancellationTextRule/utilities/getCancellationRuleDate';

import cx from './HotelsCancellationTextRule.scss';

interface IHotelsCancellationTextRuleProps extends IWithClassName {
    refundRule: IRefundRule;
}

const HotelsCancellationTextRule = (
    props: IHotelsCancellationTextRuleProps,
): ReactElement => {
    const {refundRule, className} = props;
    const {title, theme} = getCancellationTextRuleOptions(refundRule);
    const formattedDate = getCancellationRuleDate(refundRule);

    return (
        <div className={cx(className, 'root', [`root_theme_${theme}`])}>
            {title}
            <br />
            {formattedDate}
        </div>
    );
};

export default HotelsCancellationTextRule;
