import {IRefundRule} from 'types/hotels/offer/IHotelOfferCancellationInfo';

import {prepareCancellationDateTime} from 'projects/depreacted/hotels/components/HotelsCancellationInfo/utilities/prepareCancellationDateTime';
import {HUMAN_DATETIME_WITHOUT_YEAR} from 'utilities/dateUtils/formats';

import * as i18nBlock from 'i18n/hotels-CancellationInfo';

export const getCancellationRuleDate = (
    refundRule: IRefundRule,
): string | undefined => {
    const {startsAt, endsAt} = refundRule;

    const formattedStartDate = startsAt
        ? prepareCancellationDateTime(startsAt, HUMAN_DATETIME_WITHOUT_YEAR)
        : undefined;
    const formattedEndDate = endsAt
        ? prepareCancellationDateTime(endsAt, HUMAN_DATETIME_WITHOUT_YEAR)
        : undefined;

    if (formattedStartDate && formattedEndDate) {
        return i18nBlock.dateRange({
            startDate: formattedStartDate,
            endDate: formattedEndDate,
        });
    }

    if (formattedStartDate) {
        return i18nBlock.startDate({startDate: formattedStartDate});
    }

    if (formattedEndDate) {
        return i18nBlock.endDate({endDate: formattedEndDate});
    }

    return undefined;
};
