import React from 'react';

import {
    ERefundType,
    IRefundRule,
} from 'types/hotels/offer/IHotelOfferCancellationInfo';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/hotels-CancellationInfo';

import Price from 'components/Price/Price';

export enum ETextCancellationRuleTheme {
    RED = 'red',
    YELLOW = 'yellow',
    GREEN = 'green',
}

export interface ITextCancellationRuleOptions {
    title: React.ReactNode;
    theme: ETextCancellationRuleTheme;
}

export const getCancellationTextRuleOptions = (
    refundRule: IRefundRule,
): ITextCancellationRuleOptions => {
    const {type, penalty} = refundRule;

    switch (type) {
        case ERefundType.FULLY_REFUNDABLE: {
            return {
                title: i18nBlock.fullyRefundable(),
                theme: ETextCancellationRuleTheme.GREEN,
            };
        }

        case ERefundType.REFUNDABLE_WITH_PENALTY: {
            if (penalty) {
                const {currency, value} = penalty;
                const priceNode = <Price currency={currency} value={value} />;

                return {
                    title: insertJSXIntoKey(i18nBlock.refundableWithPenalty)({
                        priceNode,
                    }),
                    theme: ETextCancellationRuleTheme.YELLOW,
                };
            }

            return {
                title: i18nBlock.refundableWithPenaltyWithoutPrice(),
                theme: ETextCancellationRuleTheme.YELLOW,
            };
        }

        case ERefundType.NON_REFUNDABLE: {
            return {
                title: i18nBlock.nonRefundable(),
                theme: ETextCancellationRuleTheme.RED,
            };
        }

        default: {
            return {
                title: i18nBlock.nonRefundable(),
                theme: ETextCancellationRuleTheme.RED,
            };
        }
    }
};
