import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    prepareRefundableDate,
    SOME_PRICE_TYPE,
} from 'projects/depreacted/hotels/components/OfferRefundableRules/utilities/getRefundableRule/getRefundableRule';
import {HUMAN_DATETIME_WITHOUT_YEAR} from 'utilities/dateUtils/formats';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import ValueType from 'utilities/currency/ValueType';
import {CurrencyType} from 'utilities/currency/CurrencyType';

import * as insertMarkupIntoKeyBlock from 'i18n/hotels-CancelledPenaltyInfo';

import Price from 'components/Price/Price';

export interface IHotelsCancelledPenaltyInfo extends IWithClassName {
    startDate: string | undefined;
    type: string | undefined;
    penalty?: {
        amount: ValueType;
        currency: CurrencyType;
    };
}

const HotelsCancelledPenaltyInfo: React.FC<IHotelsCancelledPenaltyInfo> =
    props => {
        const {type, startDate, penalty, className} = props;

        if (type === SOME_PRICE_TYPE && penalty) {
            const {amount, currency} = penalty;
            const penaltyAmountNode = (
                <Price
                    className={className}
                    value={amount}
                    currency={currency}
                    key={amount}
                />
            );

            if (startDate) {
                return (
                    <span>
                        {insertJSXIntoKey(
                            insertMarkupIntoKeyBlock.penaltyInfoWithDate,
                        )({
                            cancelPeriod: prepareRefundableDate(
                                startDate,
                                HUMAN_DATETIME_WITHOUT_YEAR,
                            ),
                            penaltyAmountNode,
                        })}
                    </span>
                );
            }

            return (
                <span>
                    {insertJSXIntoKey(insertMarkupIntoKeyBlock.penaltyInfo)({
                        penaltyAmountNode,
                    })}
                </span>
            );
        }

        return null;
    };

export default HotelsCancelledPenaltyInfo;
