import {ComponentType} from 'react';

import {ISortType, ESortTypeHint} from 'types/hotels/search/ISortInfo';
import {IIconProps} from 'icons/types/icon';

import {IDevice} from 'reducers/common/commonReducerTypes';

import SortAscendingIconDesktop from 'icons/12/SortAscending';
import SortDescendingIconDesktop from 'icons/12/SortDescending';
import SortAscendingIconMobile from 'icons/16/SortAscending';
import SortDescendingIconMobile from 'icons/16/SortDescending';

import getSelectedSortType from './getSelectedSortType';

export default function getSortGroupIcon(
    deviceType: IDevice,
    sortTypes?: ISortType[],
    selectedSortId?: string | undefined,
): ComponentType<IIconProps> | null {
    if (!sortTypes) {
        return null;
    }

    const [firstSortType] = sortTypes;
    const selectedSortType = getSelectedSortType(sortTypes, selectedSortId);
    const {hint} = selectedSortType || firstSortType;
    const {isDesktop} = deviceType;

    switch (hint) {
        case ESortTypeHint.ascending: {
            return isDesktop
                ? SortAscendingIconDesktop
                : SortAscendingIconMobile;
        }

        case ESortTypeHint.descending: {
            return isDesktop
                ? SortDescendingIconDesktop
                : SortDescendingIconMobile;
        }

        case ESortTypeHint.none: {
            return null;
        }

        default: {
            return null;
        }
    }
}
