import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BlueLeavesIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 143 100" fill="none" focusable={false} {...props}>
        <g>
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M93.6925 31.501C95.1894 25.2621 91.2113 18.673 84.4635 16.4982C84.4415 16.4911 70.6614 12.0499 70.6614 12.0499C70.3799 12.5756 70.1411 13.1349 69.9515 13.7243C68.3285 18.769 70.9152 24.1188 75.7316 25.712L93.6925 31.501Z"
                fill="url(#paint0_linear)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M139.563 91.2686C139.402 87.0206 135.687 83.5335 130.994 83.3597C130.979 83.3591 121.396 83.0042 121.396 83.0042C121.31 83.39 121.258 83.7897 121.242 84.1997C121.109 87.7087 123.715 90.6556 127.072 90.8057L139.563 91.2686Z"
                fill="url(#paint1_linear)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M87.6053 81.3164C82.3233 61.9261 61.4762 49.8326 39.6682 54.0391C39.5969 54.0529 -4.93821 62.6432 -4.93821 62.6432C-4.91997 64.5115 -4.73367 66.4075 -4.36705 68.3121C-1.22935 84.6134 13.9302 95.4025 29.5579 92.5123L87.6053 81.3164Z"
                fill="url(#paint2_linear)"
            />
        </g>
        <defs>
            <linearGradient
                id="paint0_linear"
                x1="97.1988"
                y1="20.6027"
                x2="70.5019"
                y2="12.0136"
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#00A0E5" />
                <stop offset="1" stopColor="#0077C3" />
            </linearGradient>
            <linearGradient
                id="paint1_linear"
                x1="139.85"
                y1="83.6877"
                x2="121.288"
                y2="82.9833"
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#00A0E5" />
                <stop offset="1" stopColor="#0077C3" />
            </linearGradient>
            <linearGradient
                id="paint2_linear"
                x1="80.8268"
                y1="46.1001"
                x2="-5.4461"
                y2="62.7062"
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#00A0E5" />
                <stop offset="1" stopColor="#0077C3" />
            </linearGradient>
        </defs>
    </svg>
);

BlueLeavesIcon.defaultProps = {
    width: 81,
    height: 57,
    fill: 'currentColor',
};

export default BlueLeavesIcon;
