import React from 'react';

import {IWithClassName} from 'types/withClassName';

import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';

import cx from './NavigationButtonsSkeleton.scss';

const NavigationButtonsSkeleton: React.FC<IWithClassName> = ({className}) => {
    return (
        <div className={className}>
            <ButtonSkeleton size="l" className={cx('skeleton')} />
            <ButtonSkeleton
                size="l"
                className={cx('skeleton', 'skeleton_next')}
            />
        </div>
    );
};

export default NavigationButtonsSkeleton;
