import {FunctionComponent, ComponentType} from 'react';

import {
    IHotelOfferMeal,
    OfferMealType,
} from 'types/hotels/offer/IHotelOfferMeal';
import {IWithClassName} from 'types/withClassName';
import {IIconProps} from 'icons/types/icon';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import TextWithIcon, {TSize} from 'components/TextWithIcon/TextWithIcon';
import AllInclusiveIcon from 'icons/16/AllInclusive';
import BreakfastIcon from 'icons/16/Breakfast';
import BreakfastAndDinnerIcon from 'icons/16/BreakfastAndDinner';
import BreakfastLunchAndDinnerIcon from 'icons/16/BreakfastLunchAndDinner';
import Dinner from 'icons/16/Dinner';
import NoMealsIcon from 'icons/16/NoMeals';

/* Init Styles */
import cx from './OfferMealInfo.scss';

function getMealIcon(id: OfferMealType): ComponentType<IIconProps> {
    switch (id) {
        case 'AI':
            return AllInclusiveIcon;
        case 'UAI':
            return AllInclusiveIcon;
        case 'LAI':
            return AllInclusiveIcon;
        case 'FB':
            return BreakfastLunchAndDinnerIcon;
        case 'HB':
            return BreakfastAndDinnerIcon;
        case 'BB':
            return BreakfastIcon;
        case 'BD':
            return Dinner;
        case 'RO':
            return NoMealsIcon;
        case 'UNKNOWN':
            return NoMealsIcon;
    }
}

/* Component Types */
export interface IOfferMealInfoProps extends IWithClassName, IWithQaAttributes {
    mealInfo: IHotelOfferMeal;
    size: TSize;
    isIconHidden?: boolean;
}

const OfferMealInfo: FunctionComponent<IOfferMealInfoProps> = props => {
    const {className, size, mealInfo, isIconHidden} = props;
    const {name, id}: IHotelOfferMeal = mealInfo || {};

    if (name && id) {
        const Icon = getMealIcon(id);

        return (
            <TextWithIcon
                size={size}
                className={cx(
                    'mealInfo',
                    {mealInfo_included: Icon !== NoMealsIcon},
                    className,
                )}
                iconLeft={isIconHidden ? undefined : Icon}
                text={name}
                {...prepareQaAttributes(props)}
            />
        );
    }

    return null;
};

export default OfferMealInfo;
