import {PureComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {
    IBookOfferCancellationInfo,
    IBookOfferRefundableRule,
} from 'server/api/HotelsBookAPI/types/IBookOffer';

import {getRefundableRuleRenderProps} from './utilities/getRefundableRule/getRefundableRule';

import Price from 'components/Price/Price';

import cx from './OfferRefundableRules.scss';

export enum OFFER_REFUNDABLE_THEMES {
    dark = 'dark',
    white = 'white',
}

export interface IOfferRefundableRulesProps extends IWithClassName {
    theme: OFFER_REFUNDABLE_THEMES;
    cancellationInfo: IBookOfferCancellationInfo;
}

class OfferRefundableRules extends PureComponent<IOfferRefundableRulesProps> {
    static defaultProps = {
        cancellationInfo: {
            refundable: false,
            refundableRules: [],
        },
        className: '',
        theme: OFFER_REFUNDABLE_THEMES.white,
    };

    renderRefundableRule = (
        refundableRule: IBookOfferRefundableRule,
        index: number,
    ) => {
        const {title, date, theme, price} =
            getRefundableRuleRenderProps(refundableRule);

        let amount, currency;

        if (price) {
            ({amount, currency} = price);
        }

        return (
            <div className={cx('rule')} key={index}>
                <div
                    className={cx('ruleTitle', {
                        [`ruleTitle_theme_${theme}`]: theme,
                    })}
                >
                    {title}&nbsp;
                    {typeof amount !== 'undefined' &&
                        typeof currency !== 'undefined' && (
                            <Price value={amount} currency={currency} />
                        )}
                </div>
                <div className={cx('ruleDate')}>{date}</div>
            </div>
        );
    };

    render() {
        const {
            className,
            theme,
            cancellationInfo: {refundableRules},
        } = this.props;

        return (
            refundableRules.length > 0 && (
                <div
                    className={cx(
                        'offerRefundableRules',
                        `offerRefundableRules_theme_${theme}`,
                        className,
                    )}
                >
                    {refundableRules.map(this.renderRefundableRule)}
                </div>
            )
        );
    }
}

export default OfferRefundableRules;
