import moment from 'moment';

import {IBookOfferRefundableRule} from 'server/api/HotelsBookAPI/types/IBookOffer';

import {MOSCOW_TIME_ZONE} from 'utilities/dateUtils/timezones';
import {HUMAN_DATETIME} from 'utilities/dateUtils/formats';

import * as i18nBlock from 'i18n/hotels-OfferRefundableRules';

export const NO_PENALTY_TYPE = 'NO_PENALTY';
export const SOME_PRICE_TYPE = 'SOME_PENALTY';
export const FULL_PRICE_TYPE = 'FULL_PRICE';

export const GREEN_COLOR_THEME = 'green';
export const RED_COLOR_THEME = 'red';
export const DEFAULT_COLOR_THEME = 'default';

export const prepareRefundableDate = (
    date: string,
    format: string = HUMAN_DATETIME,
) => moment.utc(date).tz(MOSCOW_TIME_ZONE).format(format);

export const getRefundableRuleRenderProps = (
    refundableRule: IBookOfferRefundableRule,
) => {
    const {
        type,
        endDate,
        startDate,
        price: {amount, currency},
    } = refundableRule;

    let title = '';
    let date = '';
    let price;
    let theme = DEFAULT_COLOR_THEME;

    switch (type) {
        case NO_PENALTY_TYPE: {
            title = i18nBlock.freeRuleTitle();
            date = i18nBlock.freeRuleDate({
                date: prepareRefundableDate(endDate),
            });
            theme = GREEN_COLOR_THEME;

            break;
        }

        case SOME_PRICE_TYPE: {
            title = i18nBlock.somePriceRuleTitle();
            price = {
                amount,
                currency,
            };

            if (startDate && endDate) {
                date = i18nBlock.somePriceRuleDate({
                    startDate: prepareRefundableDate(startDate),
                    endDate: prepareRefundableDate(endDate),
                });
            } else {
                date = i18nBlock.somePriceOpenRuleDate({
                    endDate: prepareRefundableDate(endDate),
                });
            }

            break;
        }

        case FULL_PRICE_TYPE: {
            title = i18nBlock.fullPriceRuleTitle();
            date = i18nBlock.fullPriceRuleDate({
                date: prepareRefundableDate(startDate),
            });

            theme = RED_COLOR_THEME;

            break;
        }
    }

    return {
        title,
        theme,
        date,
        price,
    };
};
