import React from 'react';

import {
    ESearchSuggestItemType,
    IHotelsSuggest,
} from 'types/hotels/common/ISearchSuggest';

import getSuggestTitleAndDescription from 'projects/depreacted/hotels/components/SearchForm/utilities/getSuggestTitleAndDescription';
import {CHAR_MIDDLE_DOT} from 'utilities/strings/charCodes';
import humanizePeriod, {humanizeDate} from 'utilities/dateUtils/humanizePeriod';

import * as aviaCrossSaleKeyset from 'i18n/avia-crossSale';

export default function renderSuggestItemDescription(
    item: IHotelsSuggest,
): React.ReactNode {
    const {type} = item.redirectParams;

    if (
        type === ESearchSuggestItemType.HISTORY ||
        type === ESearchSuggestItemType.CROSS_SALE ||
        type === ESearchSuggestItemType.CROSS_SEARCH
    ) {
        const {offerSearchParams} = item.redirectParams;

        if (offerSearchParams) {
            const {checkinDate, checkoutDate, adults, childrenAges} =
                offerSearchParams;

            return `${getDate(
                checkinDate,
                checkoutDate,
            )} ${CHAR_MIDDLE_DOT} ${aviaCrossSaleKeyset.guestsCount({
                guestsCount: adults + childrenAges.length,
            })}`;
        }
    }

    return getSuggestTitleAndDescription(item).description;
}

function getDate(
    checkinDate: string,
    checkoutDate: string | null,
): string | null {
    if (checkinDate) {
        if (checkoutDate) {
            return humanizePeriod(checkinDate, checkoutDate, {
                checkSameDate: false,
                checkAnotherEndYear: false,
            });
        }

        return humanizeDate(checkinDate);
    }

    return null;
}
