import React from 'react';
import {generatePath, useParams} from 'react-router-dom';

import {URLs} from 'constants/urls';
import {ERedirectStatusCodes} from 'constants/redirectStatusCodes';

import {IHotelSlugRouteMatch} from 'types/hotels/hotel/IHotelSlugRouteMatch';

import {internalUrl} from 'utilities/url';
import {useExperiments} from 'utilities/hooks/useExperiments';
import {useQueryByLocation} from 'utilities/hooks/useQueryByLocation';

import RedirectWithStatus from 'components/RedirectWithStatus/RedirectWithStatus';

const HotelsAdsSwitch: React.FC = () => {
    const query = useQueryByLocation();
    const params = useParams<IHotelSlugRouteMatch>();
    const {hotelsTopSnippet} = useExperiments();

    return (
        <RedirectWithStatus
            to={
                hotelsTopSnippet
                    ? internalUrl(URLs.hotelsSearch, {
                          ...query,
                          topHotelSlug: `${params.regionSlug}/${params.hotelSlug}`,
                      })
                    : internalUrl(
                          generatePath(URLs.hotelsHotelWithSlug, params),
                          query,
                      )
            }
            statusCode={ERedirectStatusCodes.PERMANENTLY}
        />
    );
};

export default HotelsAdsSwitch;
