import {FC} from 'react';
import {useSelector} from 'react-redux';

import {PRODUCTION_PROJECT_URL} from 'constants/common';

import {EHotelImageAltayStandardSize} from 'types/hotels/common/EHotelImageAltayStandardSize';
import {ELoadableReducer} from 'types/common/ELoadableReducer';

import hotelPageReducer from 'reducers/depreacted/hotels/hotelPage/reducer';

import hotelPageSelector from 'selectors/depreacted/hotels/hotel/hotelPageSelector';

import {parseImageUrlTemplate} from 'projects/depreacted/hotels/utilities/prepareAndParseImages/prepareAndParseImages';
import {hotelsURLs} from 'projects/depreacted/hotels/utilities/urls';

import withReducers from 'containers/withReducers/withReducers';

import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';
import HotelPageHelmet from 'projects/depreacted/hotels/pages/HotelPage/components/HotelPageHelmet/HotelPageHelmet';

const HotelPageMeta: FC = () => {
    const {hotelInfo} = useSelector(hotelPageSelector);

    if (!hotelInfo.data) {
        return null;
    }

    const {seoInfo, hotel} = hotelInfo.data;
    const {
        openGraph: {title: ogTitle, description: ogDescription},
    } = seoInfo;
    const hotelSlug = hotel?.hotelSlug;
    const hotelPageUrlWithSlug = hotelSlug
        ? `${PRODUCTION_PROJECT_URL}${hotelsURLs.getHotelUrl({hotelSlug})}`
        : '';
    const firstImage = hotel?.images?.[0];
    const ogImage = parseImageUrlTemplate(
        firstImage?.urlTemplate || '',
        EHotelImageAltayStandardSize.L,
        firstImage?.sizes,
    );
    const imgSizes = firstImage?.sizes ?? [];
    const ogImageSize = imgSizes.find(
        imgSize => imgSize.size === EHotelImageAltayStandardSize.L,
    );

    return (
        <>
            <HotelPageHelmet seoInfo={seoInfo} hotel={hotel} />
            <SocialSharingMeta
                url={hotelPageUrlWithSlug}
                title={ogTitle}
                description={ogDescription}
                image={ogImage}
                imageHeight={ogImageSize?.height ?? ''}
                imageWidth={ogImageSize?.width ?? ''}
                twitterCardType="summary_large_image"
            />
        </>
    );
};

export default withReducers([
    [ELoadableReducer.HOTELS_HOTEL_PAGE, hotelPageReducer],
])(HotelPageMeta);
