import React from 'react';
import {useLocation} from 'react-router-dom';

import {hotelsDefaultMeta} from 'projects/depreacted/hotels/constants/hotelsMeta';

import {getAbsoluteUrl} from 'utilities/url';

import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';

import {DefaultHotelDocumentMeta} from './DefaultHotelDocumentMeta';

export const HotelsGeoRegionMeta: React.FC = () => {
    const location = useLocation();

    return (
        <>
            <DefaultHotelDocumentMeta />
            <SocialSharingMeta
                {...hotelsDefaultMeta}
                url={getAbsoluteUrl(location.pathname)}
            />
        </>
    );
};
