import React from 'react';
import {useLocation} from 'react-router-dom';

import {ESubscriptionSource} from 'types/subscription/ESubscriptionSource';
import {ESubscriptionVerticalName} from 'types/subscription/ESubscriptionVerticalName';

import {shouldShowPopup} from 'projects/depreacted/hotels/containers/SubscriptionPopup/utilities/shouldShowPopup';

import PopupSubscription from 'containers/Subscriptions/Popup/PopupSubscription';

// TODO: удалить или вернуть в задаче - TRAVELFRONT-6275
const SubscriptionPopup: React.FC = () => {
    const location = useLocation();

    if (!shouldShowPopup(location.pathname)) {
        return null;
    }

    return (
        <PopupSubscription
            vertical={ESubscriptionVerticalName.Hotels}
            source={ESubscriptionSource.POPUP}
        />
    );
};

export default SubscriptionPopup;
