import {Location} from 'history';

import {getLastSearchTimeMarkerByLocation} from 'projects/depreacted/hotels/utilities/getLastSearchTimeMarkerQuery/getLastSearchTimeMarkerQuery';
import {usePrevious} from 'utilities/hooks/usePrevious';

export const useLastSearchTimeMarkerChange = (location: Location) => {
    const {lastSearchTimeMarker} = getLastSearchTimeMarkerByLocation(location);
    const previousLastSearchTimeMarker = usePrevious<number | undefined>(
        lastSearchTimeMarker,
    );

    return previousLastSearchTimeMarker !== lastSearchTimeMarker;
};
