import _flow from 'lodash/flow';
import {connect} from 'react-redux';

import {
    createOrderActions,
    TCreateOrderRequestActionType,
} from 'reducers/depreacted/hotels/bookAndPayPage/orderInfo/actions';
import {StoreInterface} from 'reducers/storeTypes';

import hotelsBookPayPageSelector from 'selectors/depreacted/hotels/book/hotelsBookPayPageSelector';

import bookInfoProvider, {
    IBookInfoComponentProps,
} from 'projects/depreacted/hotels/containers/BookInfoProvider/BookInfoProvider';

import BookPage from './BookPage';

const mapStateToProps = hotelsBookPayPageSelector;

const mapDispatchToProps = {
    createOrder: createOrderActions.request,
    fetchPassengers: () => {},
};

type TBookPageStateContainer = ReturnType<typeof mapStateToProps>;

interface IBookPageDispatchContainer {
    createOrder: TCreateOrderRequestActionType;
    fetchPassengers: () => void;
}

export type TBookPageContainerProps = TBookPageStateContainer &
    IBookPageDispatchContainer &
    IBookInfoComponentProps;

export default _flow(
    bookInfoProvider({
        canFetchOfferInfo: true,
        canStartOrderPolling: true,
    }),
    connect<
        TBookPageStateContainer,
        IBookPageDispatchContainer,
        {},
        StoreInterface
    >(mapStateToProps, mapDispatchToProps),
)(BookPage);
