import {connect} from 'react-redux';

import {TExperiments} from 'server/providers/experiments/types';

import {
    setBookUserSelectAction,
    TSetBookUserSelectActionType,
} from 'reducers/depreacted/hotels/bookAndPayPage/bookUserSelectOptions/actions';
import {StoreInterface} from 'reducers/storeTypes';
import {
    estimateDiscountActions,
    TEstimateDiscountActionType,
    resetPromoCodesAction,
    TResetPromoCodesActionType,
} from 'reducers/depreacted/hotels/bookAndPayPage/promoCodesInfo/actions';
import {IBookPromoCodesReducer} from 'reducers/depreacted/hotels/bookAndPayPage/promoCodesInfo/reducer';
import {
    getOrderInfoActions,
    TGetOrderInfoActionType,
    removeOrderActions,
    TRemoveOrderActionType,
} from 'reducers/depreacted/hotels/bookAndPayPage/orderInfo/actions';

import experimentsSelector from 'selectors/common/experimentsSelector';

import BookPageContent, {IBookPageContentOwnProps} from './BookPageContent';

interface IHotelsBookPageContentStateProps {
    promoCodesInfo: IBookPromoCodesReducer;
    experiments: TExperiments;
}

const mapStateToProps = (
    state: StoreInterface,
): IHotelsBookPageContentStateProps => ({
    promoCodesInfo: state.hotels.bookAndPay.promoCodesInfo,
    experiments: experimentsSelector(state),
});

export interface IBookPageContentDispatchContainer {
    setBookUserSelect: TSetBookUserSelectActionType;
    estimateDiscount: TEstimateDiscountActionType;
    resetPromoCodes: TResetPromoCodesActionType;
    startOrderPolling: TGetOrderInfoActionType;
    removeOrder: TRemoveOrderActionType;
}

const mapDispatchToProps = {
    setBookUserSelect: setBookUserSelectAction,
    estimateDiscount: estimateDiscountActions.request,
    resetPromoCodes: resetPromoCodesAction,
    startOrderPolling: getOrderInfoActions.request,
    removeOrder: removeOrderActions.request,
};

export type TBookPageContentContainerProps = IHotelsBookPageContentStateProps &
    IBookPageContentDispatchContainer;

export default connect<
    IHotelsBookPageContentStateProps,
    IBookPageContentDispatchContainer,
    IBookPageContentOwnProps,
    StoreInterface
>(
    mapStateToProps,
    mapDispatchToProps,
)(BookPageContent);
