import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/mirCashback';

import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import Text from 'components/Text/Text';
import Link from 'components/Link/Link';

import cx from './MirCashbackCart.scss';

interface IMirCashbackCartProps extends IWithClassName {
    cashback: string;
}

const MirCashbackCart: React.FC<IMirCashbackCartProps> = props => {
    const {className, cashback} = props;

    return (
        <BookingLayout.Card className={cx('root', className)} between={2}>
            <Text color="current" size="s" weight="bold" tag="div">
                {i18nBlock.cartTitle({cashback})}
            </Text>

            <Text color="current" size="s" tag="div">
                {insertJSXIntoKey(i18nBlock.cartDescription)({
                    loyaltyLink: (
                        <Link
                            key="loyaltyLink"
                            url="https://privetmir.ru/rostourism/register/"
                            target="_blank"
                            text={i18nBlock.loyaltyLinkText()}
                            theme="brand"
                        />
                    ),
                })}
            </Text>
        </BookingLayout.Card>
    );
};

export default React.memo(MirCashbackCart);
