import React from 'react';

import {IWithClassName} from 'types/withClassName';

import * as i18nBlock from 'i18n/mirCashback';

import Text from 'components/Text/Text';

interface IMirCashbackDisclaimerProps extends IWithClassName {}

const MirCashbackDisclaimer: React.FC<IMirCashbackDisclaimerProps> = props => {
    const {className} = props;

    return (
        <Text className={className} tag="div" size="s" color="secondary">
            {i18nBlock.disclaimer()}
        </Text>
    );
};

export default React.memo(MirCashbackDisclaimer);
