import {connect} from 'react-redux';
import _flow from 'lodash/flow';
import {withRouter, RouteComponentProps} from 'react-router-dom';

import {IGeoRegionSlugRouteMatch} from 'types/hotels/geoRegion/IGeoRegionSlugRouteMatch';

import {StoreInterface} from 'reducers/storeTypes';
import {
    fetchGeoRegionInfoActions,
    TFetchGeoRegionInfo,
} from 'reducers/depreacted/hotels/geoRegionPage/actions';

/* Selectors */
import geoRegionPageSelector from 'selectors/depreacted/hotels/geoRegion/geoRegionPageSelector';

import deviceTypeProvider, {
    IDeviceTypeProvider,
} from 'components/DeviceTypeProvider/DeviceTypeProvider';

/* Redux Maps */
const mapStateToProps = (state: StoreInterface) => geoRegionPageSelector(state);
const mapDispatchToProps = {
    fetchGeoRegionInfo: fetchGeoRegionInfoActions.request,
};

/* Components */
import GeoRegionPage from './GeoRegionPage';

type TGeoRegionPageStatePropsContainer = ReturnType<
    typeof geoRegionPageSelector
>;

interface IGeoRegionPageDispatchPropsContainer {
    fetchGeoRegionInfo: TFetchGeoRegionInfo;
}

export type TGeoRegionPagePropsContainer = TGeoRegionPageStatePropsContainer &
    IGeoRegionPageDispatchPropsContainer &
    RouteComponentProps<IGeoRegionSlugRouteMatch> &
    IDeviceTypeProvider;

export default _flow(
    withRouter,
    connect<
        TGeoRegionPageStatePropsContainer,
        IGeoRegionPageDispatchPropsContainer,
        RouteComponentProps<{}>,
        StoreInterface
    >(mapStateToProps, mapDispatchToProps),
    deviceTypeProvider,
)(GeoRegionPage);
