import {ReactElement} from 'react';

import {IGeoRegionSeoInfo} from 'types/hotels/geoRegion/ISeoInfo';

import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';
import DocumentMeta from 'components/DocumentMeta/DocumentMeta';
import SchemaMarkup, {
    getFAQSchemaMarkup,
} from 'components/SchemaMarkup/SchemaMarkup';

interface IGeoRegionMetaHelmetProps {
    schemaNonce: string;
    seoInfo: IGeoRegionSeoInfo;
    absoluteRegionUrl: string;
}

const GeoRegionMetaHelmet = (
    props: IGeoRegionMetaHelmetProps,
): ReactElement => {
    const {seoInfo, schemaNonce, absoluteRegionUrl} = props;

    const {
        title,
        description,
        openGraph: {
            title: ogTitle,
            description: ogDescription,
            image: ogImage,
            imageSize: ogImageSize,
        },
        schemaOrg: {faqItems},
    } = seoInfo;

    return (
        <>
            {faqItems && (
                <SchemaMarkup
                    data={getFAQSchemaMarkup(faqItems)}
                    nonce={schemaNonce}
                />
            )}
            <DocumentMeta
                title={title}
                description={description}
                canonicalUrl={absoluteRegionUrl}
            />
            <SocialSharingMeta
                url={absoluteRegionUrl}
                title={ogTitle}
                description={ogDescription}
                image={ogImage}
                imageHeight={ogImageSize?.height ?? ''}
                imageWidth={ogImageSize?.width ?? ''}
                twitterCardType="summary_large_image"
            />
        </>
    );
};

export default GeoRegionMetaHelmet;
