import React from 'react';

import {IBreadcrumbs} from 'reducers/depreacted/hotels/hotelPage/hotelInfo/types';
import {IWithClassName} from 'types/withClassName';

import {useMobile} from 'utilities/hooks/useMobile';
import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import GeoRegionPageBreadCrumbsDesktop from './GeoRegionPageBreadCrumbsDesktop/GeoRegionPageBreadCrumbsDesktop';
import GeoRegionPageBreadCrumbsMobile from './GeoRegionPageBreadCrumbsMobile/GeoRegionPageBreadCrumbsMobile';

export interface IBreadCrumbsProps extends IWithClassName, IWithQaAttributes {
    breadcrumbs: IBreadcrumbs;
}

const GeoRegionPageBreadCrumbs: React.FC<IBreadCrumbsProps> = (
    props: IBreadCrumbsProps,
) => {
    const isMobile = useMobile();

    return isMobile ? (
        <GeoRegionPageBreadCrumbsMobile {...props} />
    ) : (
        <GeoRegionPageBreadCrumbsDesktop {...props} />
    );
};

export default GeoRegionPageBreadCrumbs;
