import {FunctionComponent, ReactNode, useMemo} from 'react';

import {URLs} from 'constants/urls';
import {EProjectName} from 'constants/common';

import {TBreadcrumb} from 'server/api/HotelSearchAPI/types/IHotelBreadcrumbs';

import {internalUrl} from 'utilities/url';
import {getBreadcrumbInfo} from 'projects/depreacted/hotels/pages/GeoRegionPage/utilities/getBreadcrumbInfo';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as i18block from 'i18n/hotels-GeoRegionPage';

import ArrowIcon from 'icons/12/ArrowRight';
import Link from 'components/Link/Link';

import {IBreadCrumbsProps} from '../GeoRegionPageBreadCrumbs';

import cx from './GeoRegionPageBreadCrumbsMobile.scss';

const GeoRegionPageBreadCrumbsMobile: FunctionComponent<IBreadCrumbsProps> =
    props => {
        const {className, breadcrumbs} = props;

        const breadcrumbHotels = useMemo(() => {
            return (
                <span
                    key={0}
                    itemProp="itemListElement"
                    itemScope
                    itemType="https://schema.org/ListItem"
                >
                    <Link
                        theme="normal"
                        to={internalUrl(URLs[EProjectName.HOTELS])}
                        itemProp="item"
                    >
                        <span itemProp="name">
                            {i18block.breadCrumbHotel()}
                        </span>
                    </Link>
                    <meta itemProp="position" content={String(1)} />
                </span>
            );
        }, []);

        function renderBreadcrumb(
            breadcrumb: TBreadcrumb,
            index: number,
        ): ReactNode {
            const active = index === breadcrumbs.items.length - 1;
            const {text, link} = getBreadcrumbInfo(breadcrumb, breadcrumbs);

            const textNode = (
                <span className={cx('item')} itemProp="name">
                    {text}
                </span>
            );

            return (
                <span
                    key={index}
                    itemProp="itemListElement"
                    itemScope
                    itemType="https://schema.org/ListItem"
                >
                    <ArrowIcon className={cx('arrow')} />
                    {!active && link ? (
                        <Link to={link} theme="normal" itemProp="item">
                            {textNode}
                        </Link>
                    ) : (
                        textNode
                    )}
                    <meta itemProp="position" content={String(index + 2)} />
                </span>
            );
        }

        return (
            <div className={cx(className)} {...prepareQaAttributes(props)}>
                <div
                    className={cx('list')}
                    itemScope
                    itemType="https://schema.org/BreadcrumbList"
                >
                    {breadcrumbHotels}
                    {breadcrumbs.items.map(renderBreadcrumb)}
                </div>
            </div>
        );
    };

export default GeoRegionPageBreadCrumbsMobile;
