import React from 'react';

import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';
import {IWithClassName} from 'types/withClassName';
import {
    IRegionLinkBlock,
    IRegionLinkSetBlock,
} from 'types/hotels/geoRegion/IGeoRegionInfo';

import {useReachGoal} from 'utilities/metrika/useReachGoal';
import {hotelsURLs} from 'projects/depreacted/hotels/utilities/urls';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Card from 'components/Card/Card';
import CrossLinks, {ICrossLinkItem} from 'components/CrossLinks/CrossLinks';
import Heading from 'components/Heading/Heading';
import Flex from 'components/Flex/Flex';
import Box from 'components/Box/Box';

import cx from './RegionCrossLinks.scss';

interface IRegionCrossLinksProps extends IWithClassName {
    block: IRegionLinkSetBlock;
}

const RegionCrossLinks: React.FC<IRegionCrossLinksProps> = ({
    block,
    className,
}) => {
    const {
        data: {title, subsets},
    } = block;
    const {isMobile} = useDeviceType();

    const handleCrossLinkClick = useReachGoal(
        EHotelsGoal.HOTELS_REGION_PAGE_CROSS_LINK_WITH_FILTER_CLICK,
    );

    return (
        <Flex flexDirection="column" className={className}>
            <Heading level="2">{title}</Heading>
            <Box above={5} between={3}>
                {subsets.map(subset => (
                    <Card
                        key={subset.data.title}
                        shadow="default"
                        x={isMobile ? 4 : 8}
                        y={isMobile ? 5 : 7}
                    >
                        <CrossLinks
                            title={subset.data.title}
                            items={subset.data.links.map(subsetLinkMapper)}
                            columnsAlgorithm="shift"
                            onLinkClick={handleCrossLinkClick}
                            columnClassName={cx('column')}
                        />
                    </Card>
                ))}
            </Box>
        </Flex>
    );
};

function subsetLinkMapper({
    data: {text, urlParams},
}: IRegionLinkBlock): ICrossLinkItem {
    return {
        text,
        url: hotelsURLs.getRegionUrl(urlParams),
    };
}

export default RegionCrossLinks;
