import upperFirst from 'lodash/upperFirst';

import {
    IBreadcrumbs,
    TBreadcrumb,
} from 'server/api/HotelSearchAPI/types/IHotelBreadcrumbs';

import {hotelsURLs} from 'projects/depreacted/hotels/utilities/urls';
import {isGeoRegionBreadcrumb} from 'projects/depreacted/hotels/utilities/isGeoRegionBreadcrumb/isGeoRegionBreadcrumb';
import {isHotelBreadcrumb} from 'projects/depreacted/hotels/utilities/isHotelBreadcrumb/isHotelBreadcrumb';
import {getLastGeoRegionBreadcrumb} from 'projects/depreacted/hotels/utilities/getLastGeoRegionBreadcrumb/getLastGeoRegionBreadcrumb';

interface IBreadcrumbInfo {
    text: string;
    link: string | undefined;
}

export function getBreadcrumbInfo(
    breadcrumb: TBreadcrumb,
    breadcrumbs: IBreadcrumbs,
): IBreadcrumbInfo {
    const {slug} = breadcrumb;

    if (isGeoRegionBreadcrumb(breadcrumb)) {
        return {
            text: breadcrumb.linguistics.nominativeCase,
            link: slug
                ? hotelsURLs.getRegionUrl({regionSlug: slug})
                : undefined,
        };
    }

    if (isHotelBreadcrumb(breadcrumb)) {
        return {
            text: breadcrumb.name,
            link:
                typeof slug === 'string'
                    ? hotelsURLs.getHotelPageWithSlug(slug)
                    : undefined,
        };
    }

    const regionSlug = getLastGeoRegionBreadcrumb(breadcrumbs)?.slug;

    return {
        text: upperFirst(breadcrumb.name),
        link:
            regionSlug && slug
                ? hotelsURLs.getRegionUrl({
                      regionSlug,
                      filterSlug: slug,
                  })
                : undefined,
    };
}
