import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';

import {deviceModMobile} from 'utilities/stylesUtils';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/hotels-Budapesht';

import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';
import WhatsappM from 'icons/illustrations/Whatsapp/WhatsappM';
import HotelBookingM from 'icons/illustrations/HotelBooking/HotelBookingM';

import cx from './BudapeshtBanner.scss';

interface IBudapeshtBanner extends IWithDeviceType {}

const BudapeshtBanner: React.FC<IBudapeshtBanner> = props => {
    const {deviceType} = props;

    return (
        <Flex
            className={cx('root', deviceModMobile('root', deviceType))}
            flexDirection={deviceType.isMobile ? 'column-reverse' : 'row'}
            alignItems="center"
            justifyContent="space-between"
        >
            <Text className={cx('text')} tag="div" size={'m'}>
                {insertJSXIntoKey(i18nBlock.budapeshtHpBannerText)({
                    icon: <WhatsappM className={cx('whatsappIcon')} />,
                })}
            </Text>
            <HotelBookingM className={cx('icon')} />
        </Flex>
    );
};

export default React.memo(BudapeshtBanner);
