import {connect} from 'react-redux';
import _flow from 'lodash/flow';
import {withRouter, RouteComponentProps} from 'react-router-dom';

/* Types */
import {IHotelSlugRouteMatch} from 'types/hotels/hotel/IHotelSlugRouteMatch';

/* Types */
import {
    getHotelInfoActions,
    GetHotelInfoActionType,
    resetHotelInfoToInitialAction,
    ResetHotelInfoToInitialActionType,
    getHotelInfoOffersActions,
    GetHotelInfoOffersActionType,
    getSimilarHotelsActions,
    GetSimilarHotelsActionType,
    getAdditionalHotelInfoAction,
    GetAdditionalHotelInfoActionType,
    setHotelInfoSearchParamsAction,
    SetHotelInfoSearchParamsActionType,
    stopHotelInfoActionsAction,
    StopHotelInfoActionsActionType,
} from 'reducers/depreacted/hotels/hotelPage/hotelInfo/actions';
import {StoreInterface} from 'reducers/storeTypes';
import {resetHotelsSearchFormAction} from 'reducers/depreacted/hotels/searchForm/actions';
import {updateSearchInformation} from 'reducers/depreacted/hotels/searchInformation/actions';

/* Selectors */

import hotelPageSelector from 'selectors/depreacted/hotels/hotel/hotelPageSelector';

/* Components */
import HotelPage from './HotelPage';

/* Redux Maps */

const mapStateToProps = hotelPageSelector;

const mapDispatchToProps: IHotelPageDispatchContainer = {
    getHotelInfo: getHotelInfoActions.request,
    resetHotelInfoToInitial: resetHotelInfoToInitialAction,
    getAdditionalHotelInfo: getAdditionalHotelInfoAction,
    stopHotelInfoActions: stopHotelInfoActionsAction,
    getHotelInfoOffers: getHotelInfoOffersActions.request,
    getSimilarHotels: getSimilarHotelsActions.request,
    setHotelInfoSearchParams: setHotelInfoSearchParamsAction,
    resetHotelsSearchForm: resetHotelsSearchFormAction,
    updateSearchInformation: updateSearchInformation,
};

type THotelPagePropsContainer = ReturnType<typeof hotelPageSelector>;

interface IHotelPageDispatchContainer {
    getHotelInfo: GetHotelInfoActionType;
    resetHotelInfoToInitial: ResetHotelInfoToInitialActionType;
    getAdditionalHotelInfo: GetAdditionalHotelInfoActionType;
    stopHotelInfoActions: StopHotelInfoActionsActionType;
    getHotelInfoOffers: GetHotelInfoOffersActionType;
    getSimilarHotels: GetSimilarHotelsActionType;
    setHotelInfoSearchParams: SetHotelInfoSearchParamsActionType;
    resetHotelsSearchForm: typeof resetHotelsSearchFormAction;
    updateSearchInformation: typeof updateSearchInformation;
}

export type IHotelPageContainer = THotelPagePropsContainer &
    IHotelPageDispatchContainer &
    RouteComponentProps<IHotelSlugRouteMatch>;

export default _flow(
    withRouter,
    connect<
        THotelPagePropsContainer,
        IHotelPageDispatchContainer,
        {},
        StoreInterface
    >(mapStateToProps, mapDispatchToProps),
)(HotelPage);
