import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import IMAGES from './__docs__/images';
import Gallery from './Gallery';

export default {
    title: 'Hotels/Gallery',
    component: Gallery,
} as Meta;

export const Single: TStorybookFunctionComponent = () => (
    <Gallery
        images={IMAGES.slice(0, 1)}
        totalImageCount={1}
        onMoreImagesClick={noop}
    />
);

export const Double: TStorybookFunctionComponent = () => (
    <Gallery
        images={IMAGES.slice(0, 2)}
        totalImageCount={2}
        onMoreImagesClick={noop}
    />
);

export const Triple: TStorybookFunctionComponent = () => (
    <Gallery
        images={IMAGES.slice(0, 3)}
        totalImageCount={3}
        onMoreImagesClick={noop}
    />
);

export const Quadruple: TStorybookFunctionComponent = () => (
    <Gallery
        images={IMAGES.slice(0, 4)}
        totalImageCount={4}
        onMoreImagesClick={noop}
    />
);

export const Many: TStorybookFunctionComponent = () => (
    <Gallery images={IMAGES} totalImageCount={62} onMoreImagesClick={noop} />
);
