import {connect} from 'react-redux';

import {
    getHotelImagesActions,
    GetHotelImagesActionType,
} from 'reducers/depreacted/hotels/hotelPage/hotelImages/actions';
import {StoreInterface} from 'reducers/storeTypes';

import hotelImagesTabSelector, {
    IHotelImagesTabSelector,
} from 'selectors/depreacted/hotels/hotel/imagesTab/hotelImagesTabSelector';

import HotelPageCardImagesTab from './HotelImages';

const mapStateToProps = hotelImagesTabSelector;

interface IHotelPageCardImagesTabStateContainer
    extends IHotelImagesTabSelector {}

const mapDispatchToProps = {
    getHotelImages: getHotelImagesActions.request,
};

interface IHotelPageCardImagesTabDispatchContainer {
    getHotelImages: GetHotelImagesActionType;
}

export type IHotelPageCardImagesTabContainer =
    IHotelPageCardImagesTabDispatchContainer &
        IHotelPageCardImagesTabStateContainer;

export default connect<
    IHotelPageCardImagesTabStateContainer,
    IHotelPageCardImagesTabDispatchContainer,
    {},
    StoreInterface
>(
    mapStateToProps,
    mapDispatchToProps,
)(HotelPageCardImagesTab);
