import {FunctionComponent, useCallback, CSSProperties} from 'react';

import Image from 'components/TravelImage/TravelImage';

import cx from './HotelImagesImage.scss';

export interface IHotelImagesImageProps {
    src: string;
    imageIndex: number;
    onImageClick: (index: number) => void;
    className?: string;
    imageClassName?: string;
    imageAlt?: string;
    style?: CSSProperties;
}

const HotelImagesImage: FunctionComponent<IHotelImagesImageProps> = props => {
    const {
        src,
        imageIndex,
        onImageClick,
        className,
        imageClassName,
        imageAlt,
        style,
    } = props;

    const handleImageClick = useCallback(() => {
        onImageClick(imageIndex);
    }, [onImageClick, imageIndex]);

    return (
        <Image
            className={cx('root', className)}
            imageClassName={cx('image', imageClassName)}
            imageAlt={imageAlt}
            style={style}
            src={src}
            onClick={handleImageClick}
        />
    );
};

export default HotelImagesImage;
