import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IHotelRoom} from 'types/hotels/offer/IHotelRoom';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlockRooms from 'i18n/hotels-HotelPageRooms';

import LinkButton from 'components/LinkButton/LinkButton';

export interface IHotelPageRoomDetailedInfoButtonRedesignProps
    extends IWithClassName,
        IWithQaAttributes {
    room: IHotelRoom;
    handleMoreInfoClick?: () => void;
}

const HotelPageRoomDetailedInfoButton: FunctionComponent<IHotelPageRoomDetailedInfoButtonRedesignProps> =
    ({className, room, handleMoreInfoClick, ...rest}) => {
        const {description, amenityGroups} = room;

        if (!amenityGroups?.length && !description) {
            return null;
        }

        return (
            <div className={className} {...prepareQaAttributes(rest)}>
                <LinkButton onClick={handleMoreInfoClick}>
                    {i18nBlockRooms.moreInformationAboutRoom()}
                </LinkButton>
            </div>
        );
    };

export default HotelPageRoomDetailedInfoButton;
