import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IHotelRoom} from 'types/hotels/offer/IHotelRoom';

/* Components */
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Heading from 'components/Heading/Heading';
import AmenityGroups from 'projects/depreacted/hotels/pages/HotelPage/components/OffersInfo/components/Rooms/components/AmenityGroups/AmenityGroups';
import Amenities from 'projects/depreacted/hotels/pages/HotelPage/components/OffersInfo/components/Rooms/components/Amenities/Amenities';

/* Styles */
import cx from './MobileHotelPageRoomDetailedInfo.scss';

export interface IMobileHotelPageRoomDetailedInfoProps extends IWithClassName {
    room: IHotelRoom;
}

const MobileHotelPageRoomDetailedInfo: FunctionComponent<IMobileHotelPageRoomDetailedInfoProps> =
    ({room}) => {
        const deviceType = useDeviceType();
        const {name, description, amenityGroups, mainAmenities} = room;

        if (!amenityGroups?.length && !description && !mainAmenities?.length) {
            return null;
        }

        return (
            <div>
                <Heading level={3} className={cx('title')}>
                    {name}
                </Heading>
                <Amenities
                    className={cx('mainAmenities')}
                    amenities={mainAmenities}
                    amenityFontWeight="bold"
                    amenityTextSize="m"
                    viewType="column"
                    deviceType={deviceType}
                />
                <AmenityGroups
                    className={cx('amenityGroups')}
                    amenityGroups={amenityGroups}
                    amenityGroupNameFontWeight="bold"
                    amenityTextSize="m"
                    viewType="column"
                    canRenderIcons={false}
                />
                {Boolean(description) && (
                    <div className={cx('description')}>{description}</div>
                )}
            </div>
        );
    };

export default MobileHotelPageRoomDetailedInfo;
