import React from 'react';
import {Location} from 'history';

import {IBreadcrumbs} from 'reducers/depreacted/hotels/hotelPage/hotelInfo/types';
import {IWithClassName} from 'types/withClassName';

import HotelPageBreadCrumbsDesktop from './components/HotelPageBreadCrumbsDesktop/HotelPageBreadCrumbsDesktop';
import HotelPageBreadCrumbsMobile from './components/HotelPageBreadCrumbsMobile/HotelPageBreadCrumbsMobile';

import DeviceTypeContext from 'contexts/DeviceTypeContext';

export interface IBreadCrumbsProps extends IWithClassName {
    hotelName: string;
    hotelStars?: number;
    breadcrumbs: IBreadcrumbs;
    location: Location<any>;
}

/** TODO: 💀 DeadCode - https://st.yandex-team.ru/TRAVELFRONT-6523 */
const HotelPageBreadCrumbs = (props: IBreadCrumbsProps) => {
    const {isMobile} = React.useContext(DeviceTypeContext);

    return isMobile ? (
        <HotelPageBreadCrumbsMobile {...props} />
    ) : (
        <HotelPageBreadCrumbsDesktop {...props} />
    );
};

export default HotelPageBreadCrumbs;
