import {FC, ReactNode} from 'react';

import {IGeoRegion} from 'types/hotels/hotel/IGeoRegion';

import {getHotelNameWithStars} from 'projects/depreacted/hotels/utilities/getHotelNameWithStars/getHotelNameWithStars';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {hotelsURLs} from 'projects/depreacted/hotels/utilities/urls';

import Breadcrumbs from 'components/Breadcrumbs/Breadcrumbs';
import Link from 'components/Link/Link';
import LinkButton from 'components/LinkButton/LinkButton';

import {IBreadCrumbsProps} from '../../HotelPageBreadCrumbs';

import cx from './HotelPageBreadCrumbsDesktop.scss';

/** TODO: 💀 DeadCode - https://st.yandex-team.ru/TRAVELFRONT-6523 */
const HotelPageBreadCrumbsDesktop: FC<IBreadCrumbsProps> = ({
    className,
    hotelName,
    hotelStars,
    breadcrumbs,
    location,
}: IBreadCrumbsProps) => {
    function renderBreadcrumb({geoId, linguistics}: IGeoRegion): ReactNode {
        const hotelsSearchUrl = hotelsURLs.getHotelsSearchUrl(location, geoId);

        return (
            <Breadcrumbs.Item key={geoId} className={cx('breadCrumbLink')}>
                <Link theme="ghost" to={hotelsSearchUrl}>
                    {linguistics.nominativeCase}
                </Link>
            </Breadcrumbs.Item>
        );
    }

    return (
        <div
            className={cx(className)}
            {...prepareQaAttributes('hotelBreadcrumbs')}
        >
            <Breadcrumbs x={0} hasBorder>
                {breadcrumbs.geoRegions.map(renderBreadcrumb)}
                <Breadcrumbs.Item
                    active
                    className={cx('breadCrumbLink', 'breadCrumbLink_active')}
                >
                    <LinkButton theme="black">
                        {`${getHotelNameWithStars({
                            name: hotelName,
                            stars: hotelStars,
                        })}`}
                    </LinkButton>
                </Breadcrumbs.Item>
            </Breadcrumbs>
        </div>
    );
};

export default HotelPageBreadCrumbsDesktop;
