import React, {FunctionComponent, ReactNode} from 'react';

import {IGeoRegion} from 'types/hotels/hotel/IGeoRegion';

import {getHotelNameWithStars} from 'projects/depreacted/hotels/utilities/getHotelNameWithStars/getHotelNameWithStars';
import {hotelsURLs} from 'projects/depreacted/hotels/utilities/urls';

import * as i18block from 'i18n/hotels-HotelPage';

import ArrowIcon from 'icons/12/ArrowRight';
import Link from 'components/Link/Link';

import {IBreadCrumbsProps} from '../../HotelPageBreadCrumbs';

import cx from './HotelPageBreadCrumbsMobile.scss';

/** TODO: 💀 DeadCode - https://st.yandex-team.ru/TRAVELFRONT-6523 */
const HotelPageBreadCrumbsMobile: FunctionComponent<IBreadCrumbsProps> = ({
    className,
    hotelName,
    hotelStars,
    breadcrumbs,
    location,
}) => {
    function renderBreadcrumb({geoId, linguistics}: IGeoRegion): ReactNode {
        const hotelsSearchUrl = hotelsURLs.getHotelsSearchUrl(location, geoId);

        return (
            <React.Fragment key={geoId}>
                <Link theme="normal" to={hotelsSearchUrl}>
                    {`${i18block.geoRegionPrefix()} ${
                        linguistics.genitiveCase
                    }`}
                </Link>
                <ArrowIcon className={cx('arrow')} />
            </React.Fragment>
        );
    }

    return (
        <div className={cx('root', className)}>
            <div className={cx('list')}>
                {breadcrumbs.geoRegions.map(renderBreadcrumb)}

                {`${getHotelNameWithStars({
                    name: hotelName,
                    stars: hotelStars,
                })}`}
            </div>
        </div>
    );
};

export default HotelPageBreadCrumbsMobile;
