import React from 'react';

import {IWithClassName} from 'types/withClassName';

import cx from './HotelPageFirstOfferSkeleton.scss';

export interface IHotelPageFirstOfferSkeletonProps extends IWithClassName {}

/** Скелетон дефолтного оффера (Мета) */
const HotelPageFirstOfferSkeleton: React.FC<IHotelPageFirstOfferSkeletonProps> =
    props => {
        const {className} = props;

        return (
            <div className={cx('root', className)}>
                <div className={cx('bone', 'minPrice')} />
                <div className={cx('bone', 'allOffersLink')} />
                <div className={cx('bone', 'allOffersButton')} />
            </div>
        );
    };

export default HotelPageFirstOfferSkeleton;
