import React from 'react';

import {IWithClassName} from 'types/withClassName';

import Separator from 'components/Separator/Separator';

import cx from './HotelPageYandexFirstOfferSkeleton.scss';

/** Скелетон дефолтного оффера (Book On Yandex) */
export interface IHotelPageFirstOfferSkeletonProps extends IWithClassName {}

const HotelPageYandexFirstOfferSkeleton: React.FC<IHotelPageFirstOfferSkeletonProps> =
    props => {
        return (
            <div className={cx('root', props.className)}>
                <div className={cx('bone', 'offerName')} />
                <div className={cx('bone', 'price')} />
                <div className={cx('bone', 'feature-1')} />
                <div className={cx('bone', 'feature-2')} />
                <div className={cx('bone', 'bookButton')} />
                <Separator className={cx('bone', 'separator')} />
                <div className={cx('bone', 'allOffersLink')} />
            </div>
        );
    };

export default HotelPageYandexFirstOfferSkeleton;
