import {IHotel} from 'types/hotels/hotel/IHotel';
import {IWithClassName} from 'types/withClassName';

import {IDevice} from 'reducers/common/commonReducerTypes';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceMods} from 'utilities/stylesUtils';

/* Componets */
import YandexMaps, {
    useYandexMapInstance,
} from 'components/YandexMaps/YandexMaps';

import HotelPageMapMarker from '../HotelPageMapMarker/HotelPageMapMarker';

/* Styles */
import cx from './HotelPageCardMap.scss';

/* Component Types */
interface IHotelPageCardMapTabProps extends IWithClassName, IWithQaAttributes {
    hotel: IHotel;
    canRenderAddress: boolean;
    deviceType: IDevice;
}

/* Constants */
const MAP_QA = 'map';
const MAP_PROVIDER_QUERY = {
    ns: 'use-load-map-tab',
    load: 'package.full',
};

const HotelPageCardMap = (props: IHotelPageCardMapTabProps) => {
    const {className, hotel, canRenderAddress, deviceType} = props;
    const {coordinates} = hotel;
    const [yandexMapAPIInstance, handleMapLoad] = useYandexMapInstance();

    return (
        <div
            className={className}
            {...prepareQaAttributes({
                parent: props,
                current: MAP_QA,
            })}
        >
            <YandexMaps
                defaultCenter={coordinates}
                onLoadMap={handleMapLoad}
                providerQuery={MAP_PROVIDER_QUERY}
                customControlsClassName={cx(deviceMods('controls', deviceType))}
                hasZoomControl
                hasGeoLocationControl
            >
                <HotelPageMapMarker
                    className={cx('mapMarker')}
                    hotel={hotel}
                    yandexMapAPIInstance={yandexMapAPIInstance}
                    canRenderAddress={canRenderAddress}
                    {...prepareQaAttributes(MAP_QA)}
                />
            </YandexMaps>
        </div>
    );
};

export default HotelPageCardMap;
