import {connect} from 'react-redux';

import {
    getHotelReviewsActions,
    GetHotelReviewsActionType,
    filterHotelReviewsActions,
    FilterHotelReviewsActionType,
} from 'reducers/depreacted/hotels/hotelPage/reviews/list/actions';
import {StoreInterface} from 'reducers/storeTypes';

import hotelReviewsTabSelector, {
    IHotelFeatureRatingsSelector,
} from 'selectors/depreacted/hotels/hotel/reviewsTab/hotelReviewsTabSelector';

import HotelPageCardReviewsTabRedesign from './HotelPageCardReviewsTabRedesign';

const mapStateToProps = hotelReviewsTabSelector;

const mapDispatchToProps = {
    getHotelReviews: getHotelReviewsActions.request,
    filterHotelReviews: filterHotelReviewsActions,
};

interface IHotelPageCardReviewsTabStateContainer
    extends IHotelFeatureRatingsSelector {}

interface IHotelPageCardReviewsTabDispatchContainer {
    getHotelReviews: GetHotelReviewsActionType;
    filterHotelReviews: FilterHotelReviewsActionType;
}

export type IHotelPageCardReviewsTabContainer =
    IHotelPageCardReviewsTabDispatchContainer &
        IHotelPageCardReviewsTabStateContainer;

export default connect<
    IHotelPageCardReviewsTabStateContainer,
    IHotelPageCardReviewsTabDispatchContainer,
    {},
    StoreInterface
>(
    mapStateToProps,
    mapDispatchToProps,
)(HotelPageCardReviewsTabRedesign);
