import {PureComponent, ReactNode} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import HotelReviewsRedesign from 'projects/depreacted/hotels/components/HotelReviews/HotelReviewsContainerRedesign';

import {IHotelPageCardReviewsTabContainer} from './HotelPageCardReviewsTabContainerRedesign';

/* Constants */
const REVIEWS_LOAD_COUNT = 10;
const HOTEL_REVIEWS_TAB_QA = 'hotelReviewsTab';

/* Component Types */
interface IHotelPageCardReviewsTabProps
    extends IHotelPageCardReviewsTabContainer,
        IWithClassName,
        IWithDeviceType {}

class HotelPageCardReviewsTabRedesign extends PureComponent<IHotelPageCardReviewsTabProps> {
    /* Handlers */
    private handleMoreReviews = (): void => {
        const {
            hotelReviews: {
                data,
                isLoading,
                activeKeyPhrase,
                currentSortingOption,
            },
            getHotelReviews,
        } = this.props;

        if (!isLoading && data.hasMore) {
            getHotelReviews({
                textReviewOffset: data.textReviews.length,
                textReviewLimit: REVIEWS_LOAD_COUNT,
                keyPhraseFilter: activeKeyPhrase,
                textReviewRanking: currentSortingOption,
            });
        }
    };

    private handleKeyPhraseClick = (keyPhraseEvent: string): void => {
        const {
            filterHotelReviews,
            hotelReviews: {activeKeyPhrase},
        } = this.props;

        const keysPhrase =
            activeKeyPhrase === keyPhraseEvent ? undefined : keyPhraseEvent;

        filterHotelReviews({
            textReviewLimit: REVIEWS_LOAD_COUNT,
            keyPhraseFilter: keysPhrase,
        });
    };

    /* Render */

    private renderHotelReviews(): ReactNode {
        const {
            hotelReviews: {data},
            deviceType,
        } = this.props;

        if (data) {
            return (
                <HotelReviewsRedesign
                    isActiveTab
                    isLazyLoading
                    deviceType={deviceType}
                    onKeyPhraseClick={this.handleKeyPhraseClick}
                    onMoreReviews={this.handleMoreReviews}
                />
            );
        }

        return null;
    }

    render(): ReactNode {
        const {className} = this.props;

        return (
            <div
                className={className}
                {...prepareQaAttributes(HOTEL_REVIEWS_TAB_QA)}
            >
                {this.renderHotelReviews()}
            </div>
        );
    }
}

export default HotelPageCardReviewsTabRedesign;
