import React from 'react';

import {IHotel} from 'types/hotels/hotel/IHotel';
import {IWithClassName} from 'types/withClassName';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

/* Components */
import YandexStaticMaps from 'components/YandexStaticMaps/YandexStaticMaps';
import HotelPageMapMarkerContent from 'projects/depreacted/hotels/pages/HotelPage/components/HotelPageMapMarker/HotelPageMapMarkerContent/HotelPageMapMarkerContent';

/* Styles */
import cx from './HotelPageGeoInfo.scss';

/* Component Types */
interface IHotelPageGeoInfoProps extends IWithClassName {
    hotel: IHotel;
    onMapClick: () => void;
}

/* Constants */
// Размер изображения задаю максимально возможный, чтобы более качественно выглядела карта
const STATIC_MAP_SIZE = [450, 450];
const STATIC_MAP_IMG_SIZE = {
    width: 320,
    height: 320,
};
const STATIC_MAP_ZOOM = 13;
const STATIC_MAP_SCALE = '2.0';
const HOTEL_GEO_INFO_QA = 'hotelPageGeoInfo';

const HotelPageGeoInfo: React.FC<IHotelPageGeoInfoProps> = props => {
    const {hotel, onMapClick} = props;
    const {coordinates, address} = hotel;

    function renderMarker() {
        return (
            <HotelPageMapMarkerContent
                className={cx('geoPositionMapMarker')}
                hotel={hotel}
                canRenderAddress={false}
                {...prepareQaAttributes(HOTEL_GEO_INFO_QA)}
            />
        );
    }

    return (
        <div
            className={cx('geoPositionInfo')}
            {...prepareQaAttributes(HOTEL_GEO_INFO_QA)}
        >
            <div className={cx('geoPositionInfoTitle')}>Отель на карте</div>
            <div
                className={cx('geoPositionInfoAddress')}
                {...prepareQaAttributes({
                    parent: HOTEL_GEO_INFO_QA,
                    current: 'address',
                })}
            >
                {address}
            </div>
            <div className={cx('geoPositionInfoMap')}>
                <YandexStaticMaps
                    layer="map"
                    coordinates={coordinates}
                    width={STATIC_MAP_IMG_SIZE.width}
                    height={STATIC_MAP_IMG_SIZE.height}
                    size={STATIC_MAP_SIZE}
                    zoom={STATIC_MAP_ZOOM}
                    scale={STATIC_MAP_SCALE}
                    {...prepareQaAttributes({
                        parent: HOTEL_GEO_INFO_QA,
                        current: 'map',
                    })}
                />
                {renderMarker()}
                <div className={cx('actionLayer')} onClick={onMapClick} />
            </div>
        </div>
    );
};

export default HotelPageGeoInfo;
